/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.UnsafeAllocator$1;
import com.google.gson.internal.UnsafeAllocator$2;
import com.google.gson.internal.UnsafeAllocator$3;
import com.google.gson.internal.UnsafeAllocator$4;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public abstract class UnsafeAllocator {
    public static final UnsafeAllocator INSTANCE = UnsafeAllocator.create();

    public abstract <T> T newInstance(Class<T> var1);

    private static void assertInstantiable(Class<?> clazz) {
        String string = ConstructorConstructor.checkInstantiable(clazz);
        if (string != null) {
            throw new AssertionError((Object)("UnsafeAllocator is used for non-instantiable type: " + string));
        }
    }

    private static UnsafeAllocator create() {
        try {
            Class<?> clazz = Class.forName("sun.misc.Unsafe");
            Field field = clazz.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            Object object = field.get(null);
            Method method = clazz.getMethod("allocateInstance", Class.class);
            return new UnsafeAllocator$1(method, object);
        }
        catch (Exception exception) {
            try {
                Method method = ObjectStreamClass.class.getDeclaredMethod("getConstructorId", Class.class);
                method.setAccessible(true);
                int n = (Integer)method.invoke(null, Object.class);
                Method method2 = ObjectStreamClass.class.getDeclaredMethod("newInstance", Class.class, Integer.TYPE);
                method2.setAccessible(true);
                return new UnsafeAllocator$2(method2, n);
            }
            catch (Exception exception2) {
                try {
                    Method method = ObjectInputStream.class.getDeclaredMethod("newInstance", Class.class, Class.class);
                    method.setAccessible(true);
                    return new UnsafeAllocator$3(method);
                }
                catch (Exception exception3) {
                    return new UnsafeAllocator$4();
                }
            }
        }
    }

    static /* synthetic */ void access$000(Class clazz) {
        UnsafeAllocator.assertInstantiable(clazz);
    }
}

